<?php
include 'db.php';

// Capture POST data
$duration = $_POST['duration'] ?? '';
$startDate = $_POST['startDate'] ?? '';
$endDate = $_POST['endDate'] ?? '';
$startTime = $_POST['startTime'] ?? '';
$endTime = $_POST['endTime'] ?? '';

// Log for debugging
error_log("Filters received: Duration=$duration, Start=$startDate $startTime, End=$endDate $endTime");

// Build SQL Query based on filters
$query = "SELECT id, productid, productname, amount, taps, timedate 
          FROM transacetion  
          WHERE delete_status = 0";

// Apply date filters
if (!empty($startDate) && !empty($endDate)) {
    $query .= " AND DATE(timedate) BETWEEN '$startDate' AND '$endDate'";
}
if (!empty($startTime) && !empty($endTime)) {
    $query .= " AND TIME(timedate) BETWEEN '$startTime' AND '$endTime'";
}

// Execute the query
$result = mysqli_query($connection, $query);

// Check if data is available
if (!$result || mysqli_num_rows($result) === 0) {
    echo json_encode(["success" => false, "message" => "No data found for the selected filters"]);
    exit;
}

// Prepare Excel data

$excelData = "ID\tProduct Name\tAmount\tQty\tTotal Amount\tDate & Time\n"; 
while ($row = mysqli_fetch_assoc($result)) {
    $totalAmount = $row['amount'] * $row['taps'];
    $excelData .= "{$row['id']}\t{$row['productname']}\t{$row['amount']}\t{$row['taps']}\t{$totalAmount}\t{$row['timedate']}\n";
}

// Save Excel data to file
$excelFileName = "Transaction_report_" . time() . ".xls";
$filePath = "reports/" . $excelFileName;

if (file_put_contents($filePath, $excelData) !== false) {
    // Insert into database
    $reportGenerated = date("Y-m-d H:i:s");
    $sql = "INSERT INTO report (reports, duration, reportgenerated, excelname, datastatus, createrid, editorid) 
            VALUES ('Transaction Report', '$duration', '$reportGenerated', '$filePath', '0', 0, 0)";
    
    if (mysqli_query($connection, $sql)) {
        echo json_encode([
            "success" => true, 
            "message" => "Report generated successfully",
            "file_url" => $filePath
        ]);
    } else {
        error_log("Database insert failed: " . mysqli_error($connection));
        echo json_encode(["success" => false, "message" => "Failed to save report to database"]);
    }
} else {
    error_log("Failed to create Excel file.");
    echo json_encode(["success" => false, "message" => "Failed to create Excel file"]);
}
?>
